---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Method Not Allowed通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.RouterTree.NextCaller.pas` 行121 - FResponse.Send('Method Not Allowed').Status(THTTPStatus.MethodNotAllowed)
- E-02: `src/Horse.Core.RouterTree.NextCaller.pas` 行95 - FCallBack.TryGetValue(FHTTPType, LCallback)
- E-03: `src/Horse.Core.RouterTree.NextCaller.pas` 行118 - if FCallBack.Count > 0 then
- E-04: `src/Horse.Core.RouterTree.NextCaller.pas` 行120 - FFound^ := True
- E-05: `src/Horse.Core.RouterTree.NextCaller.pas` 行124 - FResponse.Send('Not Found').Status(THTTPStatus.NotFound)
- E-06: `src/Horse.Commons.pas` 行50 - MethodNotAllowed = 405
- E-07: `src/Horse.Core.RouterTree.NextCaller.pas` 行33 - FCallBack: TObjectDictionary<TMethodType, TList<THorseCallback>>
- E-08: `src/Horse.Commons.pas` 行49 - NotFound = 404

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPステータス405が返却される | E-01, E-06 | ○ |
| C-02 | メッセージは「Method Not Allowed」 | E-01 | ○ |
| C-03 | TryGetValueがFalseの場合に判定処理に入る | E-02 | ○ |
| C-04 | FCallBack.Count > 0 が405の条件 | E-03 | ○ |
| C-05 | FFound^ := True が設定される | E-04 | ○ |
| C-06 | FCallBack.Count = 0 の場合は404 | E-03, E-05 | ○ |
| C-07 | THTTPStatus.MethodNotAllowedの値は405 | E-06 | ○ |
| C-08 | FCallBackはTMethodTypeをキーとする辞書 | E-07 | ○ |
| C-09 | THTTPStatus.NotFoundの値は404 | E-08 | ○ |
| C-10 | FResponse.SendとStatusのメソッドチェーン | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
- すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている
- 備考: RFC 7231によるとAllowヘッダーを含めるべきだが、現在の実装には含まれていない

## 6) レビュアーチェックリスト（最小）
- [ ] `Horse.Core.RouterTree.NextCaller.pas`の行121で405エラーが送信されることを確認
- [ ] 行118のFCallBack.Count > 0 条件を確認
- [ ] 行124の404との分岐を確認
